﻿#pragma   once

#if       !defined(INCLUDED_STD_MEMORY)
#include  <memory>
#endif // !defined(INCLUDED_STD_MEMORY)

#if       !defined(INCLUDED_SZ_ARCHIVE_OPEN_CLIENT_CALLBACK)
#include  <szArchiveOpenClientCallback.hpp>
#endif // !defined(INCLUDED_SZ_ARCHIVE_OPEN_CLIENT_CALLBACK)

#if       !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)
#include  <szForwardDeclarations.hpp>
#endif // !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)

// アーカイブ処理を行うクラスはコールバックを継承したりして複雑になるため、シェルフォルダとは独立して実装する方がよい。
// また、同一アーカイブ内の異なるシェルフォルダがリソースを共有するためにも、所有関係を一本化しておくと便利。
class ArchiveVolumeInfo : public szpp::ArchiveOpenClientCallback
{
public:

  ArchiveVolumeInfo(const szstring &archivePath);
  ~ArchiveVolumeInfo();

  void Open();
  bool Opened() const { return m_Opened; }

  szpp::StoredItemContainer *GetRootContainer();

  // ArchiveOpenClientCallback
#ifndef _NO_CRYPTO
  virtual HRESULT GetPassword(szstring *password);
#endif
  virtual HRESULT SetTotal(const u64 &files, const u64 &bytes);
  virtual HRESULT SetCompleted(const u64 &files, const u64 &bytes);

private:

  bool     m_Opened;
  szstring m_Path;

  std::auto_ptr<szpp::ArchiveHandler>  m_Handler;
  std::auto_ptr<szpp::ArchiveVolume>   m_Volume;
  std::auto_ptr<szpp::ArchiveContent>  m_Content;
};
